"""
$Id: toolbox.py,v 1.1 2004/12/29 09:55:54 clebeaupin Exp $
"""

__author__  = ''
__docformat__ = 'restructuredtext'

# Python imports
from StringIO import StringIO
import Globals
import sys
import os

# CMF imports
from Products.CMFCore.utils import getToolByName

def check_filesystem(self, types=None, path=None):
    """Check all files. Is a file associated with an ATCT.
    Warning: Make sure uid_catalog is ok.
    """
    
    out = StringIO()
    portal_uids = []
    fs_uids = []
    utool = getToolByName(self, 'uid_catalog')
    
    if path is None:
        path = os.path.join(Globals.INSTANCE_HOME, 'var')
    
    if types is None:
        types = ['File', 'PloneExFile']
    
    out.write('Begin analyze in %s.\n' % path)
    
    # Get all uids from portal
    brains = utool(portal_type=types)
    
    for brain in brains:
        portal_uids.append(brain.UID)
    
    # Walk into filesystem
    for root, dirs, files in os.walk(path):
        if root == path:
            # Loop on files
            for item in files:
                words = item.split('_')
                
                if len(words) == 2 and len(words[0]) == 32:
                    uid = words[0]
                    fs_uids.append(uid)
    
    # Check portal uids not in fs uids
    out.write('Check portal uids not in filesystem uids.\n')
    errors_count = 0
    
    for uid in portal_uids:
        if uid not in fs_uids:
            out.write('%s failed.\n' % uid)
            errors_count += 1
    
    oks_count = len(portal_uids) - errors_count
    out.write('%d OK, %d FAILED.\n\n' % (oks_count, errors_count))
    
    
    # Check fs uids not in portal uids
    out.write('Check filesystem uids not in portal uids.\n')
    errors_count = 0
    
    for uid in fs_uids:
        if uid not in portal_uids:
            out.write('%s failed.\n' % uid)
            errors_count += 1
    
    oks_count = len(fs_uids) - errors_count
    out.write('%d OK, %d FAILED.\n\n' % (oks_count, errors_count))
    
    out.write('Analyze completed.\n')
    return out.getvalue()
