"""
$Id: FSSTestCase.py,v 1.2 2005/03/30 14:21:12 clebeaupin Exp $
"""

# Python imports
import os
import time
import Globals

# Zope imports
from Testing import ZopeTestCase
from AccessControl.SecurityManagement import newSecurityManager
from AccessControl.SecurityManagement import noSecurityManager

# CMF imports
from Products.CMFCore.utils import getToolByName

# Plone imports
from Products.PloneTestCase import PloneTestCase

# Products imports
from Products.FileSystemStorage.config import INSTALL_EXAMPLE_TYPES_ENVIRONMENT_VARIABLE

# Globals
portal_name = 'portal'
portal_owner = 'portal_owner'
default_user = PloneTestCase.default_user
default_password = PloneTestCase.default_password

STORAGE_PATH = os.path.join(Globals.INSTANCE_HOME, 'var', 'fsstmp')

DATA_PATH = os.path.join(os.curdir, 'data')
CONTENT_PATH = os.path.join(DATA_PATH, 'word.doc')
CONTENT_TXT = """mytestfile"""

class FSSTestCase(PloneTestCase.PloneTestCase):

    class Session(dict):
        def set(self, key, value):
            self[key] = value

    def _setup(self):
        PloneTestCase.PloneTestCase._setup(self)
        self.app.REQUEST['SESSION'] = self.Session()
        base_path = STORAGE_PATH
        
        # Create temporary dir to run test cases
        if not os.path.exists(base_path):
            os.mkdir(base_path)
            
        # Configure tool
        self.fss_tool = getToolByName(self.portal, 'portal_fss')
        self.fss_tool.storage_path = STORAGE_PATH
        self.fss_tool.backup_path = STORAGE_PATH
        
    def beforeTearDown(self):
        """Remove all the stuff again.
        """
        base_path = STORAGE_PATH
        for root, dirs, files in os.walk(base_path, topdown=None):
            for name in files:
                os.remove(os.path.join(root, name))
            for name in dirs:
                os.rmdir(os.path.join(root, name))
        if os.path.exists(base_path):
            os.rmdir(base_path)

    def getDataPath(self):
        """Returns data path used for test cases"""
    
        return DATA_PATH
    
    def loginAsPortalOwner(self):
        '''Use if you need to manipulate an article as member.'''
        uf = self.app.acl_users
        user = uf.getUserById(portal_owner).__of__(uf)
        newSecurityManager(None, user)

    def addFileByString(self, folder, content_id):
        """Adds a file by string.
        """
        
        folder.invokeFactory('FSSItem', id=content_id)
        content = getattr(folder, content_id)
        get_transaction().commit(1)
        kw = {'file' : CONTENT_TXT}
        content.edit(**kw)
        return content

    def addFileByFileUpload(self, folder, content_id):
        """Adds a file by file upload.
        """
        
        folder.invokeFactory('FSSItem', id=content_id)
        content = getattr(folder, content_id)
        get_transaction().commit(1)
        self.updateContent(content, 'file', CONTENT_PATH)
        return content

    def updateContent(self, content, field, filepath):
        """Updates a field content for a file.
        """
        
        from dummy import FileUpload
        file = open(filepath, 'rb')
        file.seek(0)
        filename = filepath.split('/')[-1]
        fu = FileUpload(filename=filename, file=file)
        kw = {field: fu}
        content.edit(**kw)

# Install FSS Example types
os.environ[INSTALL_EXAMPLE_TYPES_ENVIRONMENT_VARIABLE] = 'True' 
ZopeTestCase.installProduct('PortalTransforms')
ZopeTestCase.installProduct('MimetypesRegistry')
ZopeTestCase.installProduct('Archetypes')
ZopeTestCase.installProduct('FileSystemStorage')

# Setup Plone site
PloneTestCase.setupPloneSite(products=['Archetypes', 'FileSystemStorage'])
