# -*- coding: utf-8 -*-
#
# File: Extensions/Install.py
#
# Copyright (c) 2006 atReal
#
# GNU General Public License (GPL)
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
# 02110-1301, USA.
#

"""
$Id$
"""

__author__ = """atReal <contact@atreal.net> : T.Benita, J-N.Bes & M.Broquet"""
__docformat__ = 'plaintext'
__licence__ = 'GPL'

from Products.PloneDelib.config import *
from Products.Archetypes.public import listTypes
from Products.Archetypes.Extensions.utils import installTypes
from Products.PloneDelib.Extensions.utils import *
from StringIO import StringIO

from Products.PloneDelib.Extensions.portal_permissions import setPermissions

from Products.CMFCore.utils import getToolByName

def install(self):
    out = StringIO()

    installTypes(self, out,
                 listTypes(PROJECTNAME),
                 PROJECTNAME)
    
    #activate portal factory on the PloneDelib content types
    pf_tool = getToolByName(self, 'portal_factory')
    factory_types = pf_tool.getFactoryTypes()
    for type in listTypes(PROJECTNAME):
      factory_types[type['name']] = 1
    pf_tool.manage_setPortalFactoryTypes(listOfTypeIds=factory_types.keys())
    
    #install the PloneDelib skin layer
    install_subskin(self, out, globals=GLOBALS, skin_layers=["PloneDelib"])

    #install the tool
    if not hasattr(self, 'plonedelib_tool'):
      addTool = self.manage_addProduct[PROJECTNAME].manage_addTool
      addTool('PloneDelib Tool')
    
    #set portal permissions
    portal_root=getToolByName(self,'portal_url').getPortalObject()
    setPermissions(portal_root)
      
    # create the extra roles
    for role in DELIBROLES:
        if role in self.__ac_roles__:
            print >> out, 'Role "%s" is already set up in portal.' % role
        else:
            self._addRole(role)
            print >> out, 'Setting up role "%s" in portal.' % role
            
    #set the roles
    for role in DELIBROLES:
      try:
        portal_root.acl_users.addRole(role)
        print 'Setting up role "%s" in portal.acl_users' % role
      except:
        print 'Role "%s" is already set up in portal.acl_users' % role
    
    #create the groups
    groups_tool = getToolByName(self,'portal_groups')
    for group in DELIBGROUPS:
        if group in groups_tool.listGroupNames():
            print >> out, 'Group "%s" is already set up in portal.' %group
        else:
            groups_tool.addGroup(group)
            print >> out,'Setting up group "%s" in portal.' %group
    
    #install the workflows
    from Products.PloneDelib.Extensions import act_workflow
    from Products.PloneDelib.Extensions import meeting_workflow
    wf_tool = getToolByName(self, 'portal_workflow')
    if not 'act_workflow' in wf_tool.objectIds():
            wf_tool.manage_addWorkflow('act_workflow (Act Workflow [PloneDelib])',
                                       'act_workflow')
    if not 'meeting_workflow' in wf_tool.objectIds():
            wf_tool.manage_addWorkflow('meeting_workflow (Meeting Workflow [PloneDelib])',
                                       'meeting_workflow')
    wf_tool.setChainForPortalTypes(pt_names=['Act'],
                                       chain='act_workflow')
    wf_tool.setChainForPortalTypes(pt_names=['Meeting'],
                                       chain='meeting_workflow')
    wf_tool.setChainForPortalTypes(pt_names=['Delink', 'Annex', 'Agenda', 'ShortReport', 'FullReport',
                                       'Presence', 'Proxy', 'ServiceFolder', 'Category'],
                                       chain='')

    #set default_page to home
    portal_root=getToolByName(self,'portal_url').getPortalObject()
    portal_root.default_page='home'  
    
    #Installing the cascading stylesheets
    registerStylesheets(self, out, STYLESHEETS)
    
    #Installing the javascripts
    registerScripts(self, out, JAVASCRIPTS)
    
    
    print >> out, "Successfully installed %s." % PROJECTNAME
    return out.getvalue()

def uninstall(self):
    out = StringIO()
    #remove the PloneDelib skin layer
    uninstall_subskin(self, out, "PloneDelib")
    print >> out, "Successfully uninstalled %s." % PROJECTNAME
    return out.getvalue()
