# -*- coding: utf-8 -*-
#
# File: content/act.py
#
# Copyright (c) 2006 atReal
#
# GNU General Public License (GPL)
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
# 02110-1301, USA.
#

"""
$Id: act.py 922 2006-12-22 13:07:47Z drjnut $
"""

__author__ = """atReal <contact@atreal.net> : T.Benita, M.Broquet & J-N.Bes"""
__docformat__ = 'plaintext'
__licence__ = 'GPL'


from AccessControl import ClassSecurityInfo
from Products.Archetypes.atapi import *
from Products.PloneDelib.config import *
from Products.CMFCore.utils import getToolByName
from Products.ATContentTypes.content.base import ATCTFolder
from Products.ATContentTypes.content.schemata import ATContentTypeSchema
from Products.ARFilePreview.content import * 
from Products.ATContentTypes.content.base import updateActions

schema = Schema((

    #Rapporteur
    StringField(
        name='official',
        isMetadata=True,
        widget=StringWidget(
            label='Rapporteur',
            label_msgid='PloneDelib_label_official',
            i18n_domain='PloneDelib',
        )
    ),

    #Numero
    StringField(
        name='number',
        widget=StringWidget(
            label='Numéro',
            label_msgid='PloneDelib_label_number',
            i18n_domain='PloneDelib',
        )
    ),

    #Référence
    StringField(
        name='reference',
        widget=StringWidget(
            label='Référence',
            label_msgid='PloneDelib_label_reference',
            i18n_domain='PloneDelib',
        )
    ),
    
    #Choix des séances possibles
    StringField(
        name='meetingChoice',
        isMetadata=True,
        vocabulary='getPossibleMeeting',
        widget=SelectionWidget(
            label='Séance',
            description ="Choisissez à quelle séance du conseil vous souhaitez présentez votre délibération.",
            label_msgid='PloneDelib_label_meetingChoice',
            i18n_domain='PloneDelib',
        )
    ),

),
)

Act_schema = BaseFolderSchema.copy() + \
    schema.copy() + FilePreview.schema.copy()

Act_schema['description'].widget.description="Brève description de l'objet de la délibération (facultatif)"
Act_schema['description'].widget.label='Résumé'
Act_schema['description'].widget.i18n_domain='plonedelib'
Act_schema['title'].required=1
Act_schema['OriginalFile'].widget.description="Choisissez le fichier à uploader en cliquant sur 'Parcourir'"
Act_schema['OriginalFile'].widget.label='Note de synthèse'
Act_schema['OriginalFile'].required=0

class Act(ATCTFolder, FilePreview):
    """ Délibération. Dérive de FilePreview pour stocker le 
        fichier bureautique (Note de synthèse). Dérive de 
        ATCTFolder pour le stockage des annexes.
    """
    security = ClassSecurityInfo()

    # This name appears in the 'add' box
    archetype_name = 'Délibération'

    meta_type = 'Act'
    portal_type = 'Act'
    allowed_content_types = ['Annex']
    filter_content_types = 1
    #global_allow = 0
    content_icon = 'act_icon.gif'
    typeDescription = "Act"
    typeDescMsgId = 'description_edit_legislativeact'

    _at_rename_after_creation = True

    schema = Act_schema
    
    actions = updateActions(FilePreview,
      (
        {
            'id':               "delete",
            'name':             "Delete",
            'action':           """python:"%s/object_delete"%(object.isDefaultPageInFolder() and object.getParentNode().absolute_url() or object_url)""",
            'condition':        """python:(not portal.portal_membership.checkPermission("Delete objects", object.aq_inner.getParentNode())) and portal.portal_membership.checkPermission("PloneDelib: Add Act", object.aq_inner.getParentNode()) and object is not portal and not (object.isDefaultPageInFolder() and object.getParentNode() is portal)""",
            'permissions':   ("PloneDelib: Add Act",),
            'category':      "object_buttons",
        },
      )
    )
    
    def __init__(self, oid, **kwargs):
      ATCTFolder.__init__(self, oid, **kwargs)
    
    
    #########
    ## Method overloaded by ATCTFolder
    #########
    
    def __bobo_traverse__(self, REQUEST, name):
      return FilePreview.__bobo_traverse__(self, REQUEST, name)
    
    def at_post_create_script(self):
      ATCTFolder.at_post_edit_script(self)
      FilePreview.at_post_edit_script(self)
    
    def at_post_edit_script(self):
      ATCTFolder.at_post_edit_script(self)
      FilePreview.at_post_edit_script(self)
    
    
    security.declarePrivate('getPossibleMeeting')
    def getPossibleMeeting(self):
      """ Renvoie les séances du conseil ouvertes
          retour : [(uid_seance,title),]
      """
      pc = getToolByName(self,'portal_catalog')
      brains = pc(portal_type='Meeting')
      return ['Aucune',] \
        + [item.Title for item in brains if item.review_state=='preparation']
    
    def updateTiteul(self, newTitle=None, num=-1):
      pass

##    def isAllowedToAddToMeeting(self):
##        self.
    
    def addToMeeting(self, meetingSelect=None):
        """
        Adds the current act to the selected meeting
        """
        categUid = self.REQUEST.get('categSelect', False)
        if not categUid:
          return
##        tt = getToolByName(self, 'portal_types')
        categ = self.uid_catalog(UID=categUid)[0].getObject()
        delinkId = categ.invokeFactory(type_name="Delink", id=self.getId(), title=self.Title())
##        delinkId = tt.constructContent(type_name="Delink", container=categ, id=self.getId(), title=self.Title())
        categ[delinkId].setTargetUID(self.UID())
        self.REQUEST.RESPONSE.redirect(self.absolute_url())
        # Optionally pass a message to display to the user
        #self.REQUEST.RESPONSE.appendCookie('portal_status_message', "Délibération plannifiée")
        self.portal_workflow.doActionFor(self, 'plan')
        return self.REQUEST.RESPONSE

registerType(Act, PROJECTNAME)
