<?xml version="1.0" encoding="UTF-8"?><xsl:stylesheet xmlns:com="http://www.xemelios.org/namespaces#cg-1.0" xmlns:data="http://odm-budgetaire.org/data" xmlns:date="http://exslt.org/dates-and-times" xmlns:db="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:dc="http://www.minefi.gouv.fr/cp/demat/doccomptable" xmlns:dcfu="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:exomile="http://www.fr.gouv.finances.dgfip.exomile" xmlns:lien="http://odm-budgetaire.org/utils/lien" xmlns:n="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:num="http://odm-budgetaire.org/utils/num" xmlns:style="http://odm-budgetaire.org/utils/style" xmlns:table="http://odm-budgetaire.org/utils/table" xmlns:xad="http://uri.etsi.org/01903/v1.2.2#" xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" extension-element-prefixes="num date table style lien" exclude-result-prefixes="xsl n data">
   <xsl:import href="../../number.xsl"></xsl:import>
   <xsl:import href="../../date.xsl"></xsl:import>
   <xsl:import href="../../table.xsl"></xsl:import>
   <xsl:import href="../../style.xsl"></xsl:import>
   <xsl:import href="../../lien.xsl"></xsl:import>
   <xsl:import href="../../commons/constants.xsl"></xsl:import>
   <xsl:import href="../../commons/fonctions.xsl"></xsl:import>
   <xsl:import href="../../commons/templates.xsl"></xsl:import>
   <xsl:param name="HTML_OUTPUT_FORMAT"></xsl:param>
   <xsl:param name="PDF_OUTPUT_FORMAT"></xsl:param>
   <xsl:variable name="page-format" select="portrait"></xsl:variable><xsl:output encoding="UTF-8" method="xml" indent="yes"></xsl:output><xsl:variable name="docbudg" select="/dcfu:CompteFinancierUnique"></xsl:variable>
   <xsl:param name="nomenclaturePasEnrichie"></xsl:param>
   <xsl:variable name="nomenclature" select="document('../libellePlanCompte.xml')/n:Nomenclature"></xsl:variable>
   <xsl:variable name="data" select="document('libelleAffiche.xml')/data"></xsl:variable>
   <xsl:variable name="isPrint" select="1"></xsl:variable>
   <xsl:decimal-format name="decformat" decimal-separator="," grouping-separator=" " digit="#" pattern-separator=";" NaN="NaN" minus-sign="-"></xsl:decimal-format><xsl:template match="/dcfu:CompteFinancierUnique"></xsl:template><xsl:template match="/dcfu:CompteFinancierUnique">
      <html xmlns="http://www.w3.org/1999/xhtml" xml:space="preserve">
         
         
         
         <head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
            
            
            
            
            
            <meta name="generator" content="ODM" />
            
            
            
            
            <link rel="stylesheet" type="text/css" media="screen" href="docBudg.css" />
            
            
            
            <link rel="stylesheet" type="text/css" media="print" href="docBudgPrint.css" />
            
            
            
            <style type="text/css" xml:space="preserve">
/**/
&lt;!--
 /* Font Definitions */
 @font-face
  {font-family:"Cambria Math";
  panose-1:2 4 5 3 5 4 6 3 2 4;}
 /* Style Definitions */
 p.MsoNormal, li.MsoNormal, div.MsoNormal
  {margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoHeading8, li.MsoHeading8, div.MsoHeading8
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  page-break-after:avoid;
  font-size:12.0pt;
  font-family:"Times New Roman",serif;
  font-weight:bold;}
p.MsoHeader, li.MsoHeader, div.MsoHeader
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoFooter, li.MsoFooter, div.MsoFooter
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
span.Titre8Car
  {
  
  font-family:"Times New Roman",serif;
  font-weight:bold;}
span.En-tteCar
  {
  
  font-family:"Times New Roman",serif;}
span.PieddepageCar
  {
  
  font-family:"Times New Roman",serif;}
p.notedebasdepage, li.notedebasdepage, div.notedebasdepage
  {
  margin-top:0in;
  margin-right:46.5pt;
  margin-bottom:3.0pt;
  margin-left:0in;
  text-align:justify;
  font-size:6.0pt;
  font-family:"Arial",sans-serif;}
.MsoChpDefault
  {font-family:"Calibri",sans-serif;}
.MsoPapDefault
  {margin-bottom:10.0pt;
  line-height:115%;}
 /* Page Definitions */
 @page{size:297mm 210mm;
  }
div.WordSection1
  {}
 /* List Definitions */
 ol
  {margin-bottom:0in;}
ul
  {margin-bottom:0in;}
--&gt;
/**/
}</style>
            </head>
         
         
         
         <body id="ETAT_DEPFONC" lang="EN-US">
            
            
            <div id="header">
               
               
               
               <p class="MsoHeader"><b><span style="font-size:8.0pt;font-family: &#34;Arial&#34;,&#34;sans-serif&#34;">
                        
                        <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:EnTeteDocBudgetaire/n:LibelleColl/@V)"></xsl:value-of> - 
                        
                        <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:EnTeteBudget/n:LibelleEtab/@V)"></xsl:value-of> - 
                        
                        <xsl:value-of select="distinct-values($data/data:NatureDecision/data:valeur[@value = concat($docbudg//n:Budget/n:BlocBudget/n:NatDec/@V,                         if ($docbudg//n:Budget/n:BlocBudget/n:ProjetBudget/@V = 'true') then '-proj' else '')]/text())"></xsl:value-of>  - 
                        
                        <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:BlocBudget/n:Exer/@V)"></xsl:value-of></span></b></p>
               
               </div>
            
            
            
            
            <div class="WordSection1">
               
               
               
               <div align="center">
                  
                  
                  
                  <xsl:variable name="varOdmTmpTab1">
                     
                     
                     <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none">
                        
                        
                        <tr>
                           
                           
                           <td width="86.3%" valign="top" style="border-top:double 1.5pt; border-left:double 1.5pt;border-bottom:solid 1.0pt;border-right:solid 1.0pt; border-color:black;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-size:12.0pt;font-family:&#34;Arial&#34;,sans-serif">II – EXECUTION BUDGETAIRE</span></b></p>
                              
                              </td>
                           
                           
                           <td width="13.7%" valign="top" style="border-top:double black 1.5pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-size:12.0pt;font-family:&#34;Arial&#34;,sans-serif">II</span></b></p>
                              
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           
                           <td width="86.3%" valign="top" style="border-top:none;border-left: double black 1.5pt;border-bottom:double black 1.5pt;border-right: solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">DEPENSES DE FONCTIONNEMENT – VUE D’ENSEMBLE</span></b></p>
                              
                              </td>
                           
                           
                           <td width="13.7%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 1.5pt;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoHeading8"><span lang="FR" style="font-size:10.0pt;font-family:&#34;Arial&#34;,sans-serif">A2.1</span></p>
                              
                              </td>
                           </tr>
                        </table>
                     </xsl:variable>
                  
                  
                  <xsl:call-template name="table:outputTable">
                     
                     
                     <xsl:with-param name="table" select="$varOdmTmpTab1"></xsl:with-param>
                     </xsl:call-template>
                  
                  </div>
               
               
               
               <p class="MsoNormal" style="text-align:justify"><b><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif"> </span></b></p>
               
               
               
               <div align="center">
                  
                  
                  
                  <xsl:variable name="varOdmTmpTab2">
                     
                     
                     <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none">
                        
                        <xsl:variable name="varOdm1" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(./n:CodRD/@V='D') and (./n:InfoOpe/@V='T')                         and (not(./n:Fonction/@V))]"></xsl:variable>
                        
                        
                        <thead>
                           
                           
                           
                           <tr height="0" class="#tech# #fixWidths#">
                              
                              
                              <td width="4.6%" style="border:none" rowspan="1" colspan="1"></td>
                              
                              
                              <td width="12.1%" style="border:none" rowspan="1" colspan="1"></td>
                              
                              
                              <td width="11.1%" style="border:none" rowspan="1" colspan="1"></td>
                              
                              
                              <td width="14.8%" style="border:none" rowspan="1" colspan="1"></td>
                              
                              
                              <td width="14.8%" style="border:none" rowspan="1" colspan="1"></td>
                              
                              
                              <td width="11.1%" style="border:none" rowspan="1" colspan="1"></td>
                              
                              
                              <td width="16.7%" style="border:none" rowspan="1" colspan="1"></td>
                              
                              
                              <td width="14.8%" style="border:none" rowspan="1" colspan="1"></td>
                              </tr>
                           
                           
                           
                           <tr style="height:.5in">
                              
                              
                              <td width="4.6%" valign="top" style="border-top:double 2.25pt; border-left:double 2.25pt;border-bottom:solid 1.0pt;border-right:solid 1.0pt; border-color:black;padding:0in 3.55pt 0in 3.55pt;height:.5in" rowspan="1" colspan="1">
                                 
                                 
                                 
                                 <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">Chapitre</span></b></p>
                                 
                                 </td>
                              
                              
                              <td width="12.1%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:.5in" rowspan="1" colspan="1">
                                 
                                 
                                 
                                 <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">Intitulé </span></b></p>
                                 
                                 </td>
                              
                              
                              <td width="11.1%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:.5in" rowspan="1" colspan="1">
                                 
                                 
                                 
                                 <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">Prévisions (a)</span></b></p>
                                 
                                 
                                 
                                 <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:6.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">(BP + DM + RAR N-1)</span></b></p>
                                 
                                 </td>
                              
                              
                              <td width="14.8%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:.5in" rowspan="1" colspan="1">
                                 
                                 
                                 
                                 <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">Réalisations</span></b></p>
                                 
                                 
                                 
                                 <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">Mandats émis</span></b></p>
                                 
                                 </td>
                              
                              
                              <td width="14.8%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:.5in" rowspan="1" colspan="1">
                                 
                                 
                                 
                                 <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">Rattachements (c) </span></b></p>
                                 
                                 </td>
                              
                              
                              <td width="11.1%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:.5in" rowspan="1" colspan="1">
                                 
                                 
                                 
                                 <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">Total réalisations (d = b+c) </span></b></p>
                                 
                                 </td>
                              
                              
                              <td width="16.7%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:.5in" rowspan="1" colspan="1">
                                 
                                 
                                 
                                 <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">Taux de réalisation (d/a)</span></b></p>
                                 
                                 </td>
                              
                              
                              <td width="14.8%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt;height:.5in" rowspan="1" colspan="1">
                                 
                                 
                                 
                                 <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">Restes à réaliser au 31/12 (1)</span></b></p>
                                 
                                 </td>
                              </tr>
                           
                           </thead>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm2" select="$varOdm1[(n:ChapitreNature/@V='011') and (./n:OpBudg/@V='0')]"></xsl:variable>
                           
                           
                           <td width="4.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">011</span></p>
                              
                              </td>
                           
                           
                           <td width="12.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '011' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of> (3)</span></p>
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm2/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm2/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm2/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm2/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="16.7%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPFONTXREAL011')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border:none;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm2/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm3" select="$varOdm1[(n:ChapitreNature/@V='012') and (./n:OpBudg/@V='0')]"></xsl:variable>
                           
                           
                           <td width="4.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">012</span></p>
                              
                              </td>
                           
                           
                           <td width="12.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '012' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of> (3) </span></p>
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm3/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm3/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm3/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm3/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="16.7%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPFONTXREAL012')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border:none;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm3/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm4" select="$varOdm1[(n:ChapitreNature/@V='014') and (./n:OpBudg/@V='0')]"></xsl:variable>
                           
                           
                           <td width="4.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">014</span></p>
                              
                              </td>
                           
                           
                           <td width="12.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '014' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm4/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm4/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm4/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm4/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="16.7%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPFONTXREAL014')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border:none;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm4/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm5" select="$varOdm1[(n:ChapitreNature/@V='016') and (./n:OpBudg/@V='0')]"></xsl:variable>
                           
                           
                           <td width="4.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">016</span></p>
                              
                              </td>
                           
                           
                           <td width="12.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '016' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm5/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm5/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm5/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm5/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="16.7%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPFONTXREAL016')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border:none;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm5/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm6" select="$varOdm1[(n:ChapitreNature/@V='017') and (./n:OpBudg/@V='0')]"></xsl:variable>
                           
                           
                           <td width="4.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">017</span></p>
                              
                              </td>
                           
                           
                           <td width="12.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '017' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm6/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm6/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm6/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm6/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="16.7%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPFONTXREAL017')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border:none;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm6/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm7" select="$varOdm1[(n:ChapitreNature/@V='65') and (./n:OpBudg/@V='0')]"></xsl:variable>
                           
                           
                           <td width="4.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">65</span></p>
                              
                              </td>
                           
                           
                           <td width="12.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '65' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of> (sauf 6586)</span></p>
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm7/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm7/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm7/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm7/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="16.7%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPFONTXREAL65')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border:none;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm7/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm8" select="$varOdm1[(n:ChapitreNature/@V='6586') and (./n:OpBudg/@V='0')]"></xsl:variable>
                           
                           
                           <td width="4.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">6586</span></p>
                              
                              </td>
                           
                           
                           <td width="12.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '6586' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm8/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm8/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm8/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm8/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="16.7%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPFONTXREAL6586')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm8/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           
                           <td width="16.6%" colspan="2" valign="top" style="border-top:none; border-left:double black 2.25pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Total des dépenses de gestion des services</span></b></p>
                              
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPGESCOUFON')]/n:CredOuv/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPGESCOUFON')]/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPGESCOUFON')]/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPGESCOUFON')]/n:MtReal/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="16.7%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPFONTXREALGESCOUFON')]/n:TxReal3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPGESCOUFON')]/n:MtRAR3112/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm9" select="$varOdm1[(n:ChapitreNature/@V='66') and (./n:OpBudg/@V='0')]"></xsl:variable>
                           
                           
                           <td width="4.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">66</span></p>
                              
                              </td>
                           
                           
                           <td width="12.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '66' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm9/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm9/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm9/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm9/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="16.7%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPFONTXREAL66')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border:none;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm9/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm10" select="$varOdm1[(n:ChapitreNature/@V='67') and (./n:OpBudg/@V='0')]"></xsl:variable>
                           
                           
                           <td width="4.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">67</span></p>
                              
                              </td>
                           
                           
                           <td width="12.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '67' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm10/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm10/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm10/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm10/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="16.7%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPFONTXREAL67')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border:none;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm10/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm11" select="$varOdm1[(n:ChapitreNature/@V='68') and (./n:OpBudg/@V='0')]"></xsl:variable>
                           
                           
                           <td width="4.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">68</span></p>
                              
                              </td>
                           
                           
                           <td width="12.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '68' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of> (semi-budgétaires)</span></p>
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm11/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm11/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm11/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm11/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="16.7%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPFONTXREAL68')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border:none;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm11/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           
                           <td width="16.6%" colspan="2" valign="top" style="border:solid black 1.0pt; border-left:double black 2.25pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Total des dépenses réelles et mixtes</span></b></p>
                              
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border:solid black 1.0pt; border-left:none;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXFONREL')]/n:CredOuv/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border:solid black 1.0pt; border-left:none;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXFONREL')]/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border:solid black 1.0pt; border-left:none;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXFONREL')]/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border:solid black 1.0pt; border-left:none;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXFONREL')]/n:MtReal/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="16.7%" valign="top" style="border:solid black 1.0pt; border-left:none;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPFONTXREALEXEREL')]/n:TxReal3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border-top:solid black 1.0pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXFONREL')]/n:MtRAR3112/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm12" select="$varOdm1[(n:ChapitreNature/@V='023') and (./n:OpBudg/@V='1')]"></xsl:variable>
                           
                           
                           <td width="4.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><i><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">023</span></i></p>
                              
                              </td>
                           
                           
                           <td width="12.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><i><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '023' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></i></p>
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><i><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm12/n:CredOuv/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border:none;border-right:solid black 1.0pt; background:#A6A6A6;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           
                           
                           <td width="14.8%" valign="top" style="border:none;border-right:solid black 1.0pt; background:#A6A6A6;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           
                           
                           <td width="11.1%" valign="top" style="border:none;border-right:solid black 1.0pt; background:#A6A6A6;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           
                           
                           <td width="16.7%" valign="top" style="border:none;border-right:solid black 1.0pt; background:#A6A6A6;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           
                           
                           <td width="14.8%" valign="top" style="border:none;border-right:double black 1.5pt; background:#A6A6A6;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm13" select="$varOdm1[(n:ChapitreNature/@V='042') and (./n:OpBudg/@V='1')]"></xsl:variable>
                           
                           
                           <td width="4.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><i><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">042</span></i></p>
                              
                              </td>
                           
                           
                           <td width="12.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><i><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '042' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of> (2)</span></i></p>
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><i><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm13/n:CredOuv/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><i><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm13/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><i><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm13/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><i><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm13/n:MtReal/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="16.7%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><i><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPFONTXREAL042')]/n:TxReal3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border:none;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><i><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm13/n:MtRAR3112/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm14" select="$varOdm1[(n:ChapitreNature/@V='043') and (./n:OpBudg/@V='1')]"></xsl:variable>
                           
                           
                           <td width="4.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><i><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">043</span></i></p>
                              
                              </td>
                           
                           
                           <td width="12.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><i><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '043' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></i></p>
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><i><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm14/n:CredOuv/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><i><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm14/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><i><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm14/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><i><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm14/n:MtReal/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="16.7%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><i><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPFONTXREAL043')]/n:TxReal3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><i><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm14/n:MtRAR3112/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           
                           <td width="16.6%" colspan="2" valign="top" style="border-top:none; border-left:double black 2.25pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Total des dépenses d’ordre de fonctionnement (3)</span></b></p>
                              
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXFONORD')]/n:CredOuv/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXFONORD')]/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXFONORD')]/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXFONORD')]/n:MtReal/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="16.7%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPFONTXREALEXEORD')]/n:TxReal3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXFONORD')]/n:MtRAR3112/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           
                           <td width="16.6%" colspan="2" valign="top" style="border-top:none; border-left:double black 1.5pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Total des dépenses de fonctionnement de l’exercice</span></b></p>
                              
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXFON')]/n:CredOuv/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXFON')]/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXFON')]/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXFON')]/n:MtReal/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="16.7%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPFONTXREALEXE')]/n:TxReal3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXFON')]/n:MtRAR3112/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="height:20.9pt">
                           
                           <xsl:variable name="varOdm15" select="$varOdm1[(n:ChapitreNature/@V='002') and (./n:OpBudg/@V='0')]"></xsl:variable>
                           
                           
                           <td width="16.6%" colspan="2" valign="top" style="border-top:none; border-left:double black 1.5pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt;height: 20.9pt" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">002 Déficit de fonctionnement reporté de N-1</span></b></p>
                              
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:20.9pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm15/n:CredOuv/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="14.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#A6A6A6;padding:0in 3.55pt 0in 3.55pt;height:20.9pt" rowspan="1" colspan="1"> </td>
                           
                           
                           <td width="14.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#A6A6A6;padding:0in 3.55pt 0in 3.55pt;height:20.9pt" rowspan="1" colspan="1"> </td>
                           
                           
                           <td width="11.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#A6A6A6;padding:0in 3.55pt 0in 3.55pt;height:20.9pt" rowspan="1" colspan="1"> </td>
                           
                           
                           <td width="16.7%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#A6A6A6;padding:0in 3.55pt 0in 3.55pt;height:20.9pt" rowspan="1" colspan="1"> </td>
                           
                           
                           <td width="14.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; background:#A6A6A6;padding:0in 3.55pt 0in 3.55pt;height:20.9pt" rowspan="1" colspan="1"> </td>
                           </tr>
                        
                        
                        <tr style="height:20.85pt">
                           
                           
                           <td width="16.6%" colspan="2" style="border-top:none;border-left: double black 2.25pt;border-bottom:double black 2.25pt;border-right: solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt;height:20.85pt" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">Total des dépenses de la section de fonctionnement</span></b></p>
                              
                              </td>
                           
                           
                           <td width="11.1%" style="border-top:none;border-left:none; border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:20.85pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPTOTFON')]/n:CredOuv/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="14.8%" style="border-top:none;border-left:none; border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:20.85pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPTOTFON')]/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="14.8%" style="border-top:none;border-left:none; border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:20.85pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPTOTFON')]/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:20.85pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPTOTFON')]/n:MtReal/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="16.7%" valign="top" style="border-top:none;border-left:none; border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:20.85pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPFONTXREALTOT')]/n:TxReal3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="14.8%" style="border-top:none;border-left:none; border-bottom:double black 2.25pt;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt;height:20.85pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPTOTFON')]/n:MtRAR3112/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        </table>
                     </xsl:variable>
                  
                  
                  <xsl:call-template name="table:outputTable">
                     
                     
                     <xsl:with-param name="table" select="$varOdmTmpTab2"></xsl:with-param>
                     </xsl:call-template>
                  
                  </div>
               
               
               
               <p class="MsoNormal" align="left" style="text-align:left"><b><span lang="FR" style="font-size:6.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></b></p>
               
               
               
               <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&#34;Arial&#34;,sans-serif">(1) Dépenses engagées non mandatées.</span></p>
               
               
               
               <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&#34;Arial&#34;,sans-serif">(2) Les comptes 68 peuvent figurer dans le détail du chapitre si la collectivité a
                     opté pour le régime des provisions budgétaires,
                     conformément aux dispositions législatives et réglementaires applicables.</span></p>
               
               
               
               <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&#34;Arial&#34;,sans-serif">(3) DF 042 = RI 040 ; DF 043 = RF 043</span></p>
               
               
               
               <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></p>
               
               
               
               <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&#34;Arial&#34;,sans-serif">                                                                                                                                                                                                                                                                                                                                                                 </span></p>
               
               </div>
            
            
            
            <div id="footer">
               
               <p xmlns:n="http://www.minefi.gouv.fr/cp/demat/doccfu" class="MsoNormal"><span style="font-size:8.0pt;line-height:115%">
                     
                     <xsl:if test="$HTML_OUTPUT_FORMAT">
                        
                        <xsl:variable name="link1" select="$docbudg/db:DocumentBudgetaire/db:EnTeteDocBudgetaire/db:IdColl/@V"></xsl:variable>
                        
                        <xsl:variable name="link2" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:BlocBudget/db:Exer/@V"></xsl:variable>
                        
                        <xsl:variable name="link3" select="'images/return.png'"></xsl:variable>
                        
                        <xsl:variable name="link4" select="'Accueil'"></xsl:variable>
                        
                        <xsl:variable name="link5" select="$link1"></xsl:variable>
                        
                        <xsl:variable name="link6" select="$link2"></xsl:variable>
                        
                        <xsl:call-template name="com:lienOutputImage">
                           
                           <xsl:with-param name="Param_0" select="'images/return.png'"></xsl:with-param>
                           
                           <xsl:with-param name="Param_1" select="$link3"></xsl:with-param>
                           
                           <xsl:with-param name="Param_2" select="$link4"></xsl:with-param>
                           
                           <xsl:with-param name="Param_3" select="$link5"></xsl:with-param>
                           
                           <xsl:with-param name="Param_4" select="$link6"></xsl:with-param>
                           </xsl:call-template>
                        </xsl:if></span></p>
               </div>
            </body>
         
         </html></xsl:template></xsl:stylesheet>