<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:com="http://www.xemelios.org/namespaces#cg-1.0" xmlns:exo="http://exomile.org" version="2.0">
    <!--<xsl:param name="outputFormat"/>-->
    <xsl:variable name="outputFormat">text/html</xsl:variable>

    <!-- Crée un lien de la balance vers un autre état -->
    <xsl:template name="com:accueilOutputTitle">
        <xsl:param name="Param_0" /> <!-- libellé du lien formaté par ODM-->
        <xsl:param name="Param_1" /> <!-- montant libellé du lien -->
        <xsl:param name="Param_2" /> <!-- nom de l'état -->
        <xsl:param name="Param_3" /> <!-- Fichier LienBalance -->
        <xsl:param name="Param_4" /> <!-- Siret de la collectivité -->
        <xsl:param name="Param_5" /> <!-- Exercice comptable -->
        <xsl:param name="Param_6" /> <!-- numero de compte -->
        <xsl:param name="Param_7" /> <!-- type de montant -->
        <xsl:param name="Param_8" /> <!-- codRD -->
        <xsl:param name="Param_9" /> <!-- SiretBA -->
        <xsl:param name="indice" select="1" />

        <xsl:choose>
            <xsl:when test="string-length($Param_2) = 0">
                <xsl:value-of select="$Param_1"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="com:montants">
                    <xsl:with-param name="liensComptes" select="$Param_3"/>
                    <xsl:with-param name="Exercice" select="$Param_5"/>
                    <xsl:with-param name="Siret" select="$Param_4"/>
                    <xsl:with-param name="numCompte" select="$Param_6"/>
                    <xsl:with-param name="montant" select="$Param_1"/>
                    <xsl:with-param name="typeMontant" select="$Param_7"/>
                    <xsl:with-param name="codRD" select="$Param_8"/>
                    <xsl:with-param name="siretBA" select="$Param_9"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <!-- Crée un lien de l'accueil vers un état -->
    <xsl:template name="com:lienOutputTitle">
        <xsl:param name="Param_0" /> <!-- Libellé du lien formaté par ODM -->
        <xsl:param name="Param_1" /> <!-- titre de l'état -->
        <xsl:param name="Param_2" /> <!-- nom de l'état -->
        <xsl:param name="Param_3" /> <!-- Siret de la collectivité -->
        <xsl:param name="Param_4" /> <!-- Exercice comptable -->
        <xsl:param name="Param_5" select="SiretBA" /> <!-- Siret BA -->
        <xsl:param name="indice" select="1" />
        
        
        <xsl:choose>
            <xsl:when test="string-length($Param_2) = 0">
                <xsl:value-of select="$Param_1"/>
            </xsl:when>
            <xsl:otherwise>
            	<xsl:variable name="reportExists" select="com:reportExists($Param_2, $Param_3, $Param_4, $Param_5)"/>
				<xsl:choose>
					<xsl:when test="$reportExists = true()">
						<xsl:variable name="extraFilter"></xsl:variable>
						
	                	<xsl:variable name="eltKey" select="com:makeEltKey($Param_2, $Param_3, $Param_4, $Param_5, $extraFilter)" />

	                	<xsl:call-template name="com:createKeyLink">
		                    <xsl:with-param name="key" select="com:replaceIndexInKey($eltKey,$indice)"/>
		                    <xsl:with-param name="title" select="$Param_1"/>
                		</xsl:call-template>     
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat($Param_0, ' - Cet état ne contient aucune information.')"/>
					</xsl:otherwise>
				</xsl:choose>              
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <!-- Crée un lien de l'accueil vers un état -->
    <xsl:template name="com:accueilOutputImage">
        <xsl:param name="Param_1" /> <!-- titre de l'état -->
        <xsl:param name="Param_2" /> <!-- nom de l'état -->
        <xsl:param name="Param_3" /> <!-- Siret de la collectivité -->
        <xsl:param name="Param_4" /> <!-- Exercice comptable -->
        <xsl:param name="Param_5" select="SiretBA" /> <!-- Siret BA -->
        <xsl:param name="indice" select="1" />

        <xsl:choose>
            <xsl:when test="string-length($Param_2) = 0">
                <xsl:value-of select="$Param_1"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:variable name="extraFilter"></xsl:variable>

                <xsl:variable name="eltKey" select="com:makeEltKey($Param_2, $Param_3, $Param_4, $Param_5, $extraFilter)" />

                <xsl:call-template name="com:createKeyImageLink">
                    <xsl:with-param name="key" select="com:replaceIndexInKey($eltKey,$indice)"/>
                    <xsl:with-param name="image" select="$Param_1"/>
                </xsl:call-template>                       
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <!-- Crée un lien de l'accueil vers un état -->
    <xsl:template name="com:lienOutputImage">
        <xsl:param name="Param_0" /> <!-- Libellé du lien formaté par ODM -->
        <xsl:param name="Param_1" /> <!-- titre de l'état -->
        <xsl:param name="Param_2" /> <!-- nom de l'état -->
        <xsl:param name="Param_3" /> <!-- Siret de la collectivité -->
        <xsl:param name="Param_4" /> <!-- Exercice comptable -->
        <xsl:param name="Param_5" select="SiretBA" /> <!-- Siret BA -->
        <xsl:param name="indice" select="1" />

        <xsl:choose>
            <xsl:when test="string-length($Param_2) = 0">
                <xsl:value-of select="$Param_1"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:variable name="extraFilter"></xsl:variable>

                <xsl:variable name="eltKey" select="com:makeEltKey($Param_2, $Param_3, $Param_4, $Param_5, $extraFilter)" />

                <xsl:call-template name="com:createKeyImageLink">
                    <xsl:with-param name="key" select="com:replaceIndexInKey($eltKey,$indice)"/>
                    <xsl:with-param name="image" select="$Param_1"/>
                </xsl:call-template>                       
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <!-- Crée le lien adéquoit (interne ou externe) -->
    <xsl:template name="com:createKeyLink">
        <xsl:param name="title"/>
        <xsl:param name="key"/>
        <xsl:param name="type" select="'doc'"/>
        
        <!-- les liens sont actifs que pour les liens interne ou externe en HTML -->
        <xsl:choose>
            <xsl:when test="string-length($key) &gt; 0">
                <xsl:choose>
<!--                    <xsl:when test="exo:keyExists($key)">
                        <fo:basic-link xsl:use-attribute-sets="link">
                            <xsl:attribute name="internal-destination" select="$key"/>
                            <fo:inline><xsl:value-of select="$title"/></fo:inline>
                        </fo:basic-link>
                    </xsl:when>-->
                    <xsl:when test="$outputFormat = $OUTPUT_FORMAT_HTML">
                        <xsl:element name="a">
                            <xsl:attribute name="href"><xsl:value-of select="exo:link($type, $key, $outputFormat)"/></xsl:attribute>
                            <xsl:value-of select="$title"/>
                        </xsl:element>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="$title"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$title"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <!-- Crée le lien adéquoit (interne ou externe) -->
    <xsl:template name="com:createKeyImageLink">
        <xsl:param name="image"/>
        <xsl:param name="key"/>
        <xsl:param name="type" select="'doc'"/>
        
        <!-- les liens sont actifs que pour les liens interne ou externe en HTML -->
        <xsl:choose>
            <xsl:when test="string-length($key) &gt; 0">
                <xsl:choose>
<!--                    <xsl:when test="exo:keyExists($key)">
                        <fo:basic-link xsl:use-attribute-sets="link">
                            <xsl:attribute name="internal-destination" select="$key"/>
                            <fo:inline><xsl:value-of select="$title"/></fo:inline>
                        </fo:basic-link>
                    </xsl:when>-->
                    <xsl:when test="$outputFormat = $OUTPUT_FORMAT_HTML">
                        <xsl:element name="a">
                            <xsl:attribute name="href"><xsl:value-of select="exo:link($type, $key, $outputFormat)"/></xsl:attribute>
	                        <xsl:element name="img">
	                            <xsl:attribute name="src" select="$image"/>
	                        </xsl:element>
                        </xsl:element>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:element name="img">
                            <xsl:attribute name="src" select="$image"/>
                        </xsl:element>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <xsl:element name="img">
                    <xsl:attribute name="src" select="$image"/>
                </xsl:element>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="com:montants">
        <xsl:param name="liensComptes"/>
        <xsl:param name="Exercice"/>
        <xsl:param name="Siret"/>
        <xsl:param name="numCompte"/>
        <xsl:param name="montant"/>
        <xsl:param name="typeMontant"/>
        <xsl:param name="codRD"/>
        <xsl:param name="siretBA"/>

        <xsl:variable name="lienEtat">
            <xsl:choose>
                <xsl:when test="$typeMontant = 'op-non-budg-debit'">
                    <xsl:value-of select="$liensComptes/compte[matches(com:trim($numCompte), @numero)]/@op-non-budg-debit"/>
                </xsl:when>
                <xsl:when test="$typeMontant = 'op-non-budg-credit'">
                    <xsl:value-of select="$liensComptes/compte[matches(com:trim($numCompte), @numero)]/@op-non-budg-credit"/>
                </xsl:when>
                <xsl:when test="$typeMontant = 'op-budg-debit'">
                    <xsl:value-of select="$liensComptes/compte[matches(com:trim($numCompte), @numero)]/@op-budg-debit"/>
                </xsl:when>
                <xsl:when test="$typeMontant = 'op-budg-credit'">
                    <xsl:value-of select="$liensComptes/compte[matches(com:trim($numCompte), @numero)]/@op-budg-credit"/>
                </xsl:when>
                <xsl:when test="$typeMontant = 'tot-debit'">
                    <xsl:value-of select="$liensComptes/compte[matches(com:trim($numCompte), @numero)]/@tot-debit"/>
                </xsl:when>
                <xsl:when test="$typeMontant = 'tot-credit'">
                    <xsl:value-of select="$liensComptes/compte[matches(com:trim($numCompte), @numero)]/@tot-credit"/>
                </xsl:when>
                <xsl:when test="$typeMontant = 'solde-debit'">
                    <xsl:value-of select="$liensComptes/compte[matches(com:trim($numCompte), @numero)]/@solde-debit"/>
                </xsl:when>
                <xsl:when test="$typeMontant = 'solde-credit'">
                    <xsl:value-of select="$liensComptes/compte[matches(com:trim($numCompte), @numero)]/@solde-credit"/>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>

        <xsl:choose>
            <xsl:when test="string-length($lienEtat) &gt; 0">
                <xsl:call-template name="com:createKeyLink">
                    <xsl:with-param name="key" select="com:makeBalanceLinkKey($Exercice, $Siret, $siretBA, $lienEtat, $numCompte, $montant, $codRD)"/>
                    <xsl:with-param name="title" select="com:format-number($montant)"></xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="com:format-number($montant)"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
</xsl:stylesheet>