<?xml version="1.0"?>
<!--
    Copyright
    2010 axYus - http://www.axyus.com
    2010 J.Leger - johann.leger@axyus.com

    This file is part of ODM print-comp.

    ODM print-comp is free software; you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ODM print-comp is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with ODM print-comp; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-->
<xsl:stylesheet version="2.0"
                xmlns="http://www.w3.org/1999/xhtml"
                xpath-default-namespace="http://www.w3.org/1999/xhtml"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:table="http://odm-budgetaire.org/utils/table"
                extension-element-prefixes="table">

 <xsl:template name="table:processRowStyled">
     <xsl:param name="borderStyle"/>
     <xsl:param name="rows"/>     

     <xsl:for-each select="$rows">
	 <xsl:sequence select="." />
     </xsl:for-each>
 </xsl:template>

 <xsl:template name="table:processRowBorders">
     <xsl:param name="borderStyle"/>
     <xsl:param name="rows"/>     

     <xsl:for-each select="$rows">
         <xsl:variable name="rowPosition" select="position()"/>
         <xsl:variable name="rowLast" select="last()"/>

         <xsl:copy>
             <xsl:copy-of select="@*"/>
             <xsl:for-each select="td">
                 <xsl:copy>
                     <xsl:copy-of select="@*[name()!='style']"/>
                     <xsl:attribute name="style" select="table:processBorders($borderStyle, @style, $rowPosition, $rowLast)"/>
                     <xsl:copy-of select="*"/>
                 </xsl:copy>
             </xsl:for-each>
         </xsl:copy>
     </xsl:for-each>
 </xsl:template>

 <xsl:function name="table:processBorders">
        <xsl:param name="borderStyle"/>
        <xsl:param name="style"/>
        <xsl:param name="rowPosition"/>
        <xsl:param name="lastRowPosition"/>

        <xsl:variable name="styleWithAtomicBorders">
            <xsl:choose>
                <xsl:when test="matches($style, 'border:[^;]*;?')">
                    <xsl:variable name="borderValue" select="replace($style,'^.*border:([^;]*);?.*$','$1')"/>
                    <xsl:variable name="styleNoBorder" select="replace($style,'border:[^;]*;?','')"/>                    
                    <xsl:variable name="styleWithAtomicBorderTop" select="if (matches($styleNoBorder,'border-top:[^;]*;?')) then $styleNoBorder else concat($styleNoBorder, '; border-top:', $borderValue)"/>
                    <xsl:variable name="styleWithAtomicBorderTopBottom" select="if (matches($styleWithAtomicBorderTop,'border-bottom:[^;]*;?')) then $styleWithAtomicBorderTop else concat($styleWithAtomicBorderTop, '; border-bottom:', $borderValue)"/>
                    <xsl:variable name="styleWithAtomicBorderTopBottomLeft" select="if (matches($styleWithAtomicBorderTopBottom,'border-left:[^;]*;?')) then $styleWithAtomicBorderTopBottom else concat($styleWithAtomicBorderTopBottom, '; border-left:', $borderValue)"/>                    
                    <xsl:variable name="styleWithAtomicBorderTopBottomLeftRight" select="if (matches($styleWithAtomicBorderTopBottomLeft,'border-right:[^;]*;?')) then $styleWithAtomicBorderTopBottomLeft else concat($styleWithAtomicBorderTopBottomLeft, '; border-right:', $borderValue)"/>
                    <xsl:value-of select="$styleWithAtomicBorderTopBottomLeftRight"/>                                      
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$style"/>
                </xsl:otherwise>
            </xsl:choose>          
        </xsl:variable>

        <xsl:variable name="fixedStyle">
           <xsl:choose>
               <xsl:when test="$rowPosition = 1 and $rowPosition = $lastRowPosition">
                   <xsl:value-of select="$style"/>
               </xsl:when>
               <xsl:when test="$rowPosition = 1">
                   <xsl:value-of select="replace($styleWithAtomicBorders,'border-bottom:[^;]*;?',concat('border-bottom:', $borderStyle, ';'))"/>
               </xsl:when>
               <xsl:when test="$rowPosition = $lastRowPosition">
                   <xsl:value-of select="replace($styleWithAtomicBorders,'border-top:[^;]*;?',concat('border-top:', $borderStyle, ';'))"/>
               </xsl:when>
               <xsl:otherwise>
                   <xsl:variable name="fixedTopBorderStyle" select="replace($styleWithAtomicBorders,'border-top:[^;]*;?',concat('border-top:', $borderStyle, ';'))"/>
                   <xsl:value-of select="replace($fixedTopBorderStyle,'border-bottom:[^;]*;?',concat('border-bottom:', $borderStyle, ';'))"/>                   
               </xsl:otherwise>                                            
           </xsl:choose>
        </xsl:variable>
        <xsl:value-of select="$fixedStyle"/>
  </xsl:function>

 <xsl:template name="table:outputTable">
     <xsl:param name="table"/>
     <xsl:copy-of select="$table"/>
 </xsl:template>
</xsl:stylesheet>