/**
 * @_requires OpenLayers/Control.js
 */

/**
 * Class: Carmen.Control.MapserverScale
 * Display a small line indicator representing the current map scale on the map.
 * 
 * Inherits from:
 *  - <OpenLayers.Control>
 *  
 
 */
// TODO: see why we nedd to keep openlayers namespace to make the control added on the map
// may be some filter in Openlayers.Map or OpenLayers.control
// do not forget to correctly set displayClass which is used for css assignment
OpenLayers.Control.MapserverScale = new OpenLayers.Class(OpenLayers.Control, {
    MAIN_CSS_CLASS : 'PRODIGEAPI_SCALE',
    
    // properties
    serverUrl : '',
        
    mapfile : '',

    scaleImg : null,
    
    displayTxt : true,
    displayImg : true,
    
// temp   
  font : null,
    fontFamily : 'tahoma,arial,helvetica,sans-serif',
    color : '#000000',
    fontSize : '12px',
    fontWeight : 'normal',
    fontStyle : 'normal',
    backgroundColor :  null,
    opacity : 1.0,
// temp end     
//     
    initialize: function(options) {
        //console.log('here b1');
        //Carmen.Control.Inlay.prototype.initialize.apply(this, arguments);
        //temp        
        OpenLayers.Control.prototype.initialize.apply(this, arguments);
        
        this.fontFamily = this.font ? this.font + ',' + this.fontFamily : this.fontFamily;
        if (this.fontSize && this.fontSize.search(/^\d+$/g)!=-1)
          this.fontSize = this.fontSize + 'px';
           
        if (this.color && this.color.charAt(0)!='#') 
          this.color = '#' + this.color;
        if (this.backgroundColor && this.backgroundColor.charAt(0)!='#')
          this.backgroundColor = '#' + this.backgroundColor;
        // alpha in bgcolor desc ?
        if (this.backgroundColor && this.backgroundColor.length==9) {
          this.opacity = 1.0 - (parseInt(this.backgroundColor.substring(7,9),16) / 255);
          this.backgroundColor = this.backgroundColor.substring(0,7);
        }
// temp end  
    },
  
    setMap: function(map) {
      OpenLayers.Control.prototype.setMap.apply(this, arguments);    
      if ( !this.div ){
        var mainPanel = this.map.app.ui.getMainPanel();
        if ( mainPanel ){
          var nodes = mainPanel.getElementsByClassName(this.MAIN_CSS_CLASS);
          if ( nodes.length ){
            this.div = nodes[0];
          }
        }
        this.div = OpenLayers.Util.getElement(this.MAIN_CSS_CLASS);
        if ( !this.div ){
          this.div = OpenLayers.Util.createDiv(
            OpenLayers.Util.createUniqueID(this.MAIN_CSS_CLASS+'_'),
            null,
            null,
            null,
            "absolute"
          );
          OpenLayers.Element.addClass(this.div, this.MAIN_CSS_CLASS);
          this.map.app.ui.addToDataPanel(this.div);
        } 
      }
    },
    
    /**
     * Method: draw
     * 
     * Returns:
     * {DOMElement}
     */
    draw: function() {
//        Carmen.Control.Inlay.prototype.draw.apply(this, arguments);
// temp
      OpenLayers.Control.prototype.draw.apply(this, arguments);
      
      this.div.style.display = "block";
      this.div.style.position = "absolute";
      this.div.style.backgroundColor = this.backgroundColor;
      this.div.style.fontFamily = this.fontFamily;
      this.div.style.fontWeight = this.fontWeight;
      this.div.style.color = this.color;
      this.div.style.fontSize = this.fontSize;
      this.div.style.fontStyle = this.fontStyle;
      OpenLayers.Util.modifyDOMElement(this.div, null, null, null,
                                       null, null, null, this.opacity);
//      this.update();
    
// temp end        

        if (!this.scaleImg && this.displayImg) {
          //console.log('here img');
          this.scaleImg = document.createElement("img");
          this.scaleImg.style.verticalAlign = 'top';
          this.div.appendChild(this.scaleImg);
        }    
        if (!this.scaleTxt && this.displayTxt) {
          //console.log('here txt');
          this.scaleTxt = document.createElement("span");
          this.scaleTxt.style.verticalAlign = 'top';
          this.scaleTxt.style.marginLeft = '10px';
          this.div.appendChild(this.scaleTxt);          
/*          
          this.scaleTxt.style.color = '#' + this.color;
          this.scaleTxt.style.fontFamily = this.fontFamily;
          this.scaleTxt.style.fontSize = this.fontSize;
          this.scaleTxt.style.fontWeight = this.fontWeight;
*/          
      }
      this.map.events.register('moveend', this, this.update);
      this.update();
      //TODO ProdigeViewer this.map.app.ui.getBottomToolBar().doLayout();
      return this.div;
    },

    /**
     * Method: update
     * Update the size of the bars, and the labels they contain.
     */
 
    update: function() {
      if (this.displayImg && this.scaleImg) {
        var params = {
          MAP : this.mapfile,
          MAP_IMAGETYPE : 'PNG',
          MODE : 'SCALEBAR',
          map_resolution : Carmen.Mapserver_DOTS_PER_INCH,
          SCALE : this.map.getScale()
        };
      
        this.scaleImg.src = this.serverUrl + '?' +
          OpenLayers.Util.getParameterString(params);
      }
      if (this.displayTxt && this.scaleTxt) {
        this.scaleTxt.innerHTML = this.map.getScale() ? 
          'Echelle ' + Carmen.SpecialChars["around"] + ' ' + 
           Carmen.Util.scaleTextFormater(
             Carmen.Util.roundIntToDigits(this.map.getScale())) : 
          '';
      }
      
    },
    /*
    scaleTextFormater : function(scale) {
      var denom =  parseInt(this.map.getScale()).toString();
      
      var newDenom ='';
      for (var i=0; i<denom.length; i++) {
        newDenom = denom.charAt(denom.length-1-i) + newDenom;
        if ((i+1) % 3 == 0 && (i+1)<denom.length)
          newDenom = ' ' + newDenom;  
      }
      return  'Echelle : 1 / ' + newDenom;
    }, 
 */
    CLASS_NAME: "OpenLayers.Control.MapserverScale"
});

