
/**
 * Class: Prodige.Keymap
 * Classe du controleur de la carte de situation ("Keymap", "Minimap") de la carte
 * 
 * Construction automatique et incluse dans Prodige.Map si et seulement si keymapVisible
 * 
 * Inherits from:
 *  - <OpenLayers.Control.OverviewMap>
 */
Prodige.Keymap = new OpenLayers.Class(OpenLayers.Control.OverviewMap, {

  referencePanel : null,
  
  getPanel : function(){
    this.referencePanel = this.referencePanel || OpenLayers.Util.getElement('referencePanel') 
    if ( !this.referencePanel ) {
      this.referencePanel = OpenLayers.Util.createDiv(
           'referencePanel', 
           {x: 0, y : 0},
           {w: 220, h: 110},
           null,
           "absolute",
           "1px solid black",
           "hidden",
           1.0
         );
      var mapPanel = this.map.app.ui.getMainPanel();
      mapPanel.add(this.referencePanel);
      this.map.app.ui.doLayout();
    }
    return this.referencePanel;
  },
  isHidden : true,
  /**
   * Function: show
   * Affiche la carte de situation
   */
  show : function(){
    if ( this.div ){
      this.div.style.display = "";
      this.div.style.visibility = "visible";
      this.isHidden = false;
    } else {
      this.draw();
    }
  },
  /**
   * Function: hide
   * Cache la carte de situation
   */
  hide : function(){
    if ( this.div ){
      this.div.style.display = "none";
      this.isHidden = true;
    }
  },


  initialize: function( options) {
  // todo : cahnge the way the default opt are handled, bcos mapOptions is overiden and not extended....
/*    
    options = OpenLayers.Util.extend(options,
      layerRef==null ? 
        { mapOptions : {numZoomLevels: 1} } :
        {
          mapOptions : {numZoomLevels: 1}, 
          layers : [layerRef]
        } 
    );
  */  
    
    OpenLayers.Control.OverviewMap.prototype.initialize.apply(this, [options]);
    this.displayClass = this.CLASS_NAME_EXTEND.replace("Prodige.", "prodige").replace(/\./g, "") + " "+(this.displayClass || "");
  },
 
  draw: function() {
    OpenLayers.Control.OverviewMap.prototype.draw.apply(this, arguments);
    
    if ( !this.outsideViewport ){
      if ( this.maximizeDiv ){
        this.maximizeDiv.innerHTML = '<i class="fa fa-plus"></i>';
      }
      if ( this.minimizeDiv ){
        this.minimizeDiv.innerHTML = '<i class="fa fa-minus"></i>';
      }
    }
    // adjusting heigth of the div
    var h = Math.min(this.size.h + 10,140);
    this.mapDiv.style.height = h.toString() + 'px';
    
    // and adding specific css
    var eltMapDiv = OpenLayers.Util.getElement(this.mapDiv);
    OpenLayers.Element.removeClass(eltMapDiv, 'olMap');
    OpenLayers.Element.addClass(eltMapDiv, 'cmnControlOverviewMap');
 
    // overloading css
/*    var reference = OpenLayers.Util.getElement(this.referencePanel.body.id);
    var referenceMap = reference.child('.CarmenControlOverviewMapElement');
    referenceMap.addClass('cmnReferenceMapElement');
    var referenceMapRectangle = referenceMap.child('.CarmenControlOverviewMapExtentRectangle');
    referenceMapRectangle.addClass('cmnReferenceMapExtentRectangle');
*/    
    this.isHidden = false;
    return this.div;
  },

  update : function() {
    OpenLayers.Control.OverviewMap.prototype.update.apply(this, arguments);

    // css overriding
    var eltMapDiv = OpenLayers.Util.getElement(this.mapDiv);
    OpenLayers.Element.removeClass(eltMapDiv, 'olMap');
    OpenLayers.Element.addClass(eltMapDiv, 'cmnControlOverviewMap');
  },

  CLASS_NAME_EXTEND: "Prodige.Keymap"

});
  
  
