Prodige = window.Prodige || {};
Prodige.OWSContext = Prodige.OWSContext || {};

Prodige.OWSContext.VersionProdige = new OpenLayers.Class({
  jsOws : null,
  generalExt : null,
  layer : [],
  mapProjection : null,
  
  mdataTool : null,
  mdataMap : null,
  mdataLayer : null,
  mapExtent : null,
  maxExtent : null,
  mapMinScaleDenom : null,
  mapMaxScaleDenom : null,

  initialize: function(context) {
    this.jsOws = context;
    this.generalExt = this.jsOws.ViewContext.General.Extension; 
    if (this.jsOws.ViewContext.LayerList && this.jsOws.ViewContext.LayerList.Layer) {
     this.layer = this.jsOws.ViewContext.LayerList.Layer instanceof Array ?
      this.jsOws.ViewContext.LayerList.Layer :
      [].concat(this.jsOws.ViewContext.LayerList.Layer);
     this.jsOws.ViewContext.LayerList.Layer = this.layer
    }
    this.parseMdata();
    
    //console.log(this.mdataTool);
    //console.log(this.mdataMap);
    //console.log(this.mdataLayer);
    
  },
  
  getObj : function () {
    return this.jsOws;  
  },
  
  getProjection :  function() {
    if (this.mapProjection==null)
      this.mapProjection= this.jsOws.ViewContext.General.BoundingBox.attributes.crs.split('=')[1].toLocaleUpperCase();
    
    return this.mapProjection;
  },
  
  getProjectionUnits : function() {
    if (this.mapProjectionUnits==null)
      this.mapProjectionUnits= Carmen.Util.getProjectionUnits(this.getProjection());
    return this.mapProjectionUnits;
  },
  
  getExtent :  function() {
    if (this.mapExtent==null) {
      this.mapExtent = Carmen.Util.convertContextBBtoolBounds(
        this.jsOws.ViewContext.General.BoundingBox);
    }
    return this.mapExtent;
  },
  
  getMaxExtent :  function() {
    if (this.maxExtent==null) {
      this.maxExtent = Carmen.Util.convertContextBBtoolBounds(
        this.jsOws.ViewContext.General.Extension.MaxBoundingBox);
    }
    return this.maxExtent;
  },
  
  getMaxScaleDenom : function() {
      if (this.mapMaxScaleDenom==null && 
          this.jsOws.ViewContext.General.Extension.MaxScaleDenom!=null) {
        this.mapMaxScaleDenom = parseFloat(this.jsOws.ViewContext.General.Extension.MaxScaleDenom);
        if (this.mapMaxScaleDenom ==-1) 
           this.mapMaxScaleDenom=null;
      }
      return this.mapMaxScaleDenom;
  },
  
  getMinScaleDenom : function() {
      if (this.mapMinScaleDenom==null && 
          this.jsOws.ViewContext.General.Extension.MinScaleDenom!=null) {
        this.mapMinScaleDenom = parseFloat(this.jsOws.ViewContext.General.Extension.MinScaleDenom);
        if (this.mapMinScaleDenom == -1)   
           this.mapMinScaleDenom=null;
      }
      return this.mapMinScaleDenom;
  },
  
  
  getTitle :  function() {
    return Url.decode(this.jsOws.ViewContext.General.Title);
  }, 

  getFavoriteAreas : function() {
    return this.generalExt.GeoBookmark ? this.generalExt.GeoBookmark : null;
  },
  
  setExtent : function(bounds) {
    this.jsOws.ViewContext.General.BoundingBox.attributes.minx = bounds.left;
    this.jsOws.ViewContext.General.BoundingBox.attributes.miny = bounds.bottom;
    this.jsOws.ViewContext.General.BoundingBox.attributes.maxx = bounds.right;
    this.jsOws.ViewContext.General.BoundingBox.attributes.maxy = bounds.top;
  },
  
  setLayerVisibility : function(layerIdx, visible) {
    this.jsOws.ViewContext.LayerList.Layer[layerIdx].attributes.hidden = visible ? "0" : "1";
  },
  
  setGeneralConfig : function(config) {
    for(p in config) 
     this.generalExt[p] = config[p];
  },
  
  getGeneralConfig : function(configName) {
    var config = null;
    if (configName in this.generalExt)
      config = this.generalExt[configName];
    return config;
  },
  
  isToolActiv : function(toolName) {
    var toolValue = valueFrom(this.mdataTool[toolName], "0")
    return (toolValue=="1" || toolValue=="ON" || toolValue== "simple"|| toolValue=="advanced");
  },
  
  getToolbarTarget : function(toolName) {
    var toolValue = valueFrom(this.mdataTool[toolName], "0") 
    return toolValue;
  },

  hasLayerWMSC : function() {
    var found = false;
    for (var k in this.mdataLayer) {
      if (valueFrom(this.mdataLayer[k].wmscLayer, "OFF", false)=="ON"
         && valueFrom(this.mdataLayer[k].isWmts, "NO", false)=="NO" ) {
        found = true;
        break;
      }
    }
    return found;
  }, 

  // fill hash mdataTool, mdataMap and mdataLayer 
  // with mdata from Extension parts of the context
  parseMdata : function () {
    this.mdataTool = {};
    this.mdataMap = {};
//    console.log(this.generalExt);
    for (var k in this.generalExt) {
      //console.log(k);
      var matched = k.match(/^tool_(.+)$/); 
      if (matched!=null) {
        var toolName = matched[1];
        //console.log(toolName);
        this.mdataTool[toolName] = this.generalExt[k];
      }
      else {
        matched = k.match(/^mapSettings_(.+)$/);
        if (matched!=null) {
          var setting = matched[1];
          this.mdataMap[setting] = this.generalExt[k];
        }
        else
          this.mdataMap[k] = this.generalExt[k];
      }
    }
    this.mdataLayer = {};
    if (this.layer) {
      if (this.layer instanceof Array) {
        for (var i=0; i<this.layer.length; i++) {
          var layerName =  this.layer[i].Title;
          this.mdataLayer[layerName] = {};
          for (var k in this.layer[i].Extension) {
            var matched = k.match(/^layerSettings_(.+)$/);
            var setting = matched!=null ? matched[1] : k;
            this.mdataLayer[layerName][setting] = this.layer[i].Extension[k];     
          }
        }
      }
      else {
        var layerName =  this.layer.Title;
        this.mdataLayer[layerName] = {};
        for (var k in this.layer.Extension) {
          var matched = k.match(/^layerSettings_(.+)$/);
          var setting = matched!=null ? matched[1] : k;
          this.mdataLayer[layerName][setting] = this.layer.Extension[k];     
        } 
      }
    }
  }, 
  
  
  getNextLayerId : function() {
    return this.layer.length;
  },
  
  addLayerDescs :  function(descs) {
    for (var i=0; i< descs.length; i++)
      this.layer.push(descs[i]);
    return (this.layer.length-1);
  },
  
  getLayerDescFromMdataValue : function(attributeName, value) {
    var i=0;
    for (var k in this.mdataLayer) {
      var v = valueFrom(Url.decode(this.mdataLayer[k][attributeName]), null, false);
      if (v==value) {
        break;
      }
      i++;
    }
    return i <= (this.layer.length-1) ? this.layer[i] : null;
  }
});

Prodige.OWSContext.VersionCarmen = new OpenLayers.Class({
  jsOws : null,
  generalExt : null,
  layer : [],
  mapProjection : null,
  
  mdataTool : null,
  mdataMap : null,
  mdataLayer : null,
  mapExtent : null,
  maxExtent : null,
  
  annotationAttributes : null,

  initialize: function(context) {
    this.jsOws = context;
    this.generalExt = this.jsOws.OWSContext.General.Extension; 
    if (this.jsOws.OWSContext.ResourceList.Layer)
     this.layer = this.jsOws.OWSContext.ResourceList.Layer instanceof Array ?
      this.jsOws.OWSContext.ResourceList.Layer :
      [].concat(this.jsOws.OWSContext.ResourceList.Layer);
    
    //Deal with unique result
    if (this.jsOws.OWSContext.ResourceList.Layer[0] === undefined)
     this.jsOws.OWSContext.ResourceList.Layer = [].concat(this.jsOws.OWSContext.ResourceList.Layer);
        ;
      
    this.parseMdata();
    
    //console.log(this.mdataTool);
    //console.log(this.mdataMap);
    //console.log(this.mdataLayer);
    
  },
  
  getObj : function () {
    return this.jsOws;  
  },
  
  getToolbarTarget : function(toolName) {
    var toolValue = (this.mdataTool[toolName] || "0") 
    return toolValue;
  },
  getProjection :  function() {
    if (this.mapProjection==null)
      this.mapProjection= this.jsOws.OWSContext.General.BoundingBox.attributes.crs.split('=').pop().toLocaleUpperCase();
    return this.mapProjection;
  },
  
  getProjectionUnits : function() {
    if (this.mapProjectionUnits==null)
      this.mapProjectionUnits= Carmen.Util.getProjectionUnits(this.getProjection());
    return this.mapProjectionUnits;
  },
  
  getExtent :  function() {
    if (this.mapExtent==null) {
      this.mapExtent = Carmen.Util.convertContextBBtoolBounds(
        this.jsOws.OWSContext.General.BoundingBox);
    }
    return this.mapExtent;
  },
  
  getMaxExtent :  function() {
    if (this.maxExtent==null) {
      this.maxExtent = Carmen.Util.convertContextBBtoolBounds(
        this.jsOws.OWSContext.General.MaxBoundingBox);
    }
    return this.maxExtent;
  },
  
  getMaxScaleDenom : function() {
      if (this.mapMaxScaleDenom==null && 
          this.jsOws.OWSContext.General.Extension.MAXSCALEDENOM!=null) {
        this.mapMaxScaleDenom = parseFloat(this.jsOws.OWSContext.General.Extension.MAXSCALEDENOM);
        if (this.mapMaxScaleDenom ==-1) 
           this.mapMaxScaleDenom=null;
      }
      return this.mapMaxScaleDenom;
  },
  
  getMinScaleDenom : function() {
      if (this.mapMinScaleDenom==null && 
          this.jsOws.OWSContext.General.Extension.MINSCALEDENOM!=null) {
        this.mapMinScaleDenom = parseFloat(this.jsOws.OWSContext.General.Extension.MINSCALEDENOM);
        if (this.mapMinScaleDenom == -1)   
           this.mapMinScaleDenom=null;
      }
      return this.mapMinScaleDenom;
  },
  
  // Modif SWT [P2-5] 7590 : Saisie de plusieurs attributs pour les annotations
  // On ajoute une fonction pour récupérer la liste des attributs plutôt qu'un
  // unique attribut.
  // NB : Les noms d'attributs renvoyés peuvent contenir des caractères spéciaux.
  getAnnotationAttributes : function() {
    if (this.annotationAttributes==null) {
      var attrs = null;
      if (this.mdataTool.attribut_value_annotation) {
        // Attention, il y a bien deux niveaux d'encodage !
        // La chaine complète pour encoder les séparateurs.
        attrs = decodeURIComponent(this.mdataTool.attribut_value_annotation).split(";");
        // Et chaque élément qui pourrait contenir un séparateur
        // ou des caractères spéciaux.
        for (var i = 0; i < attrs.length; i++) {
          attrs[i] = decodeURIComponent(attrs[i]);
        }
      }
      this.annotationAttributes=attrs;
    }
    return this.annotationAttributes;
  },
  
  getTitle :  function() {
    return Url.decode(this.jsOws.OWSContext.General.Title);
  }, 

  getFavoriteAreas : function() {
    //modif dds
    if(this.generalExt.GeoBookmark){
      return this.generalExt.GeoBookmark;
    }
    if(this.generalExt.zones_favorites){
      var fav=decodeURIComponent(this.generalExt.zones_favorites);
      fav=fav.replace(/'/g, '"');
      fav=fav.replace(/__G__/g, '\'');
      return JSON.parse(fav);
    }
    return this.generalExt.GeoBookmark ? this.generalExt.GeoBookmark : null;
  },
  
  setExtent : function(bounds) {
    this.jsOws.OWSContext.General.BoundingBox.LowerCorner = bounds.left + " " + bounds.bottom;
    this.jsOws.OWSContext.General.BoundingBox.UpperCorner = bounds.right + " " + bounds.top;
  },
  
  setLayerVisibility : function(layerIdx, visible) {
    this.jsOws.OWSContext.ResourceList.Layer[layerIdx].attributes.hidden = visible ? "0" : "1";
  },
  
  setGeneralConfig : function(config) {
    for(p in config) 
     this.generalExt[p] = config[p];
  },
  
  getGeneralConfig : function(configName) {
    var config = null;
    if (configName in this.generalExt)
      config = this.generalExt[configName];
    return config;
  },
  
  isToolActiv : function(toolName) {
    var toolValue = this.mdataTool[toolName] || "0"; 
    return (toolValue=="1" || toolValue=="ON");
  },
  
  // Modif SWT :
  // [P2-10] 6785 : Séparation des outils recentrer et localiser
  // [P2-14] 7527 : Recherche par numéro de parcelle
  // [P2-15] 7527 (& 7807 ): Recherche par adresse
  // J'ajoute une méthode pour savoir si la métadonnée existe.
  // Ca permet de gérer la backward compatibility :
  // Si un des 3 nouveau outils n'est pas défini, c'est que le
  // MapFile a été créé avec l'ancienne version. Et le
  // comportement n'est pas le même (voir utilisation dans
  // Application.js de Descartes).
  isToolDefined : function(toolName) {
    return this.mdataTool[toolName];
  },

  hasLayerWMSC : function() {
    var found = false;
    for (var k in this.mdataLayer) {
      if ((this.mdataLayer[k].wmscLayer || "OFF")=="ON") {
        found = true;
        break;
      }
    }
    return found;
  }, 

  // fill hash mdataTool, mdataMap and mdataLayer 
  // with mdata from Extension parts of the context
  parseMdata : function () {
    this.mdataTool = {};
    this.mdataMap = {};
    //console.log(this.generalExt);
    for (var k in this.generalExt) {
      //console.log(k);
      var matched = k.match(/^tool_(.+)$/); 
      if (matched!=null) {
        var toolName = matched[1];
        //console.log(toolName);
        this.mdataTool[toolName] = this.generalExt[k];
      }
      else {
        matched = k.match(/^mapSettings_(.+)$/);
        if (matched!=null) {
          var setting = matched[1];
          this.mdataMap[setting] = this.generalExt[k];
        }
        else
          this.mdataMap[k] = this.generalExt[k];
      }
    }
    
    this.mdataLayer = {};
    if (this.layer) {
      if (this.layer instanceof Array) {
        for (var i=0; i<this.layer.length; i++) {
          var layerName =  this.layer[i].Title;
          this.mdataLayer[layerName] = {};
          for (var k in this.layer[i].Extension) {
            var matched = k.match(/^layerSettings_(.+)$/);
            var setting = matched!=null ? matched[1] : k;
            this.mdataLayer[layerName][setting] = this.layer[i].Extension[k];     
          }
        }
      }
      else {
        var layerName =  this.layer.Title;
        this.mdataLayer[layerName] = {};
        for (var k in this.layer.Extension) {
          var matched = k.match(/^layerSettings_(.+)$/);
          var setting = matched!=null ? matched[1] : k;
          this.mdataLayer[layerName][setting] = this.layer.Extension[k];     
        } 
      }
    }
  }, 
  
  
  getNextLayerId : function() {
    return this.layer.length;
  },
  
  addLayerDescs :  function(descs) {
    for (var i=0; i< descs.length; i++)
      this.layer.push(descs[i]);
    return (this.layer.length-1);
  },
  
  getLayerDescFromMdataValue : function(attributeName, value) {
    var i=0;
    for (var k in this.mdataLayer) {
      var v = Url.decode(this.mdataLayer[k][attributeName]);
      if (v==value) {
        break;
      }
      i++;
    }
    return i <= (this.layer.length-1) ? this.layer[i] : null;
  },
  
  /**
   * @brief find the first node of layerTreeNode
   * whose attribute is equals to value
   * browsing in depth first
   */
  getLayerTreeNodeFromMdataValue : function (attributeName, value) {
    var res = null;
    if (this.mdataMap.LayerTree.LayerTreeNode!=null)
      res = this._findTreeNode(this.mdataMap.LayerTree.LayerTreeNode,attributeName, value);
    return res;
  },
  
  /**
   * @brief find the first node of subnodes 
   * whose attribute is equals to value
   */ 
  _findTreeNode: function(node, attributeName, value) {
    var res = null;
    
    if ( ('LayerTreeNode' in node) && !(node.LayerTreeNode instanceof Array) ){
      node = node.LayerTreeNode;
    }
    
    if ( (attributeName in node.attributes) && (node.attributes[attributeName]==value) ) {
      res = node;
    }
    else if ( ('LayerTreeNode' in node) && (node.LayerTreeNode instanceof Array) ) {
      for (var i=0; i<node.LayerTreeNode.length; i++) {
        var tmp = this._findTreeNode(node.LayerTreeNode[i], attributeName, value);
        if ( tmp!==null ){
          res = tmp;
          break;
        }
      }
    }
    return res;
  }
});


Prodige.OWSContextReader = function(owscontext){
  OpenLayers.Util.extend(this, {
    JSONReader : new OpenLayers.Format.JSON(),
    XMLReader : new OpenLayers.Format.XML(),
    /**
     * APIMethod: read
     * Deserialize a owscontext string and return a DOM node.
     *
     * Parameters:
     * text - {String} A XML string
     
     * Returns:
     * {DOMElement} A DOM node
     */
    read : function(owscontext){
      if ( owscontext ){
        if ( typeof owscontext=="object" && owscontext instanceof XMLDocument ){
          return this.xmlToJson(owscontext.firstChild, true);
        }
        if ( /<(OWS|View)Context[^>]*>/.test(String(owscontext)) ){
          return this.readXML(owscontext);
        }
        if ( /["']?(OWS|View)Context["']?\s*:\s*\{/.test(String(owscontext)) ){
          return this.readJSON(owscontext);
        }
      }
      throw "Prodige.Map.OWSContextReader : unsupported format for owscontext contents.";
    },
    
    readXML : function(owscontext){
      var nodeXML = this.XMLReader.read(owscontext);
      var json = {};
      return this.xmlToJson(nodeXML.firstChild, true);
    },
    
    readJSON : function(owscontext){
      return this.JSONReader.read(owscontext);
    },
    
    xmlToJson : function(xml, isRoot) {
      // Create the return object
      var obj = {};
      var root = obj;
      if ( isRoot ){
        obj[xml.tagName] = {};
        root = obj;
        obj = obj[xml.tagName];
      }
      var hasChildElement = false;
    
      if (xml.nodeType == 1) { // element
        // do attributes
        if (xml.attributes.length > 0) {
          obj["attributes"] = {};
          for (var j = 0; j < xml.attributes.length; j++) {
            hasChildElement = true;
            var attribute = xml.attributes.item(j);
            obj["attributes"][attribute.localName] = attribute.value;
          }
        }
      }
    
      // do children
      if (xml.hasChildNodes()) {
        var texts = [];
        for(var i = 0; i < xml.childNodes.length; i++) {
          var item = xml.childNodes.item(i);
          if (item.nodeType == 1) {
            hasChildElement = true;
            var nodeName = item.tagName;
            if (typeof(obj[nodeName]) == "undefined") {
              obj[nodeName] = this.xmlToJson(item);
            } else {
              if (typeof(obj[nodeName].push) == "undefined") {
                var old = obj[nodeName];
                obj[nodeName] = [];
                obj[nodeName].push(old);
              }
              obj[nodeName].push(this.xmlToJson(item));
            }
          }else if (item.nodeType == 3){
            texts.push(item);
          }
        } 
      }
      
      if ( !hasChildElement ){
        root = xml.textContent;
      }
      return root;
    }
  });
  
  var jsonContext;
  
  if ( typeof owscontext == "string" ){
    jsonContext = this.read(owscontext);
  } else if ( typeof owscontext == "object" ){
    jsonContext = owscontext;
  }

  if ( jsonContext && typeof jsonContext.OWSContext !="undefined" ){
    Prodige.OWSContext = Prodige.OWSContext.VersionCarmen;
  }
  else if ( jsonContext && typeof jsonContext.ViewContext !="undefined" ){
    Prodige.OWSContext = Prodige.OWSContext.VersionProdige;
  }
  else {
    throw "Prodige.OWSContextReader : Root of the owscontext is not recognized";
  }
  return new Prodige.OWSContext(jsonContext);
}