


(function() {
  Carmen = window.Carmen || {};
  Carmen.Control = Carmen.Control || {};
  Carmen.Layer = Carmen.Layer || {};
  /**
   * Before creating the Prodige namespace, check to see if
   * Prodige.singleFile is true.  This occurs if the
   * Prodige/SingleFile.js script is included before this one - as is the
   * case with old single file build profiles that included both
   * Prodige.js and Prodige/SingleFile.js.
   */
  var singleFile = (typeof Prodige == "object" && Prodige.singleFile);
  
  /**
   * Relative path of this script.
   */
  var scriptName = (!singleFile) ? "lib/Prodige/ProdigeViewer.js" : "ProdigeViewer.js";

  /*
   * If window.Prodige isn't set when this script (Prodige.js) is
   * evaluated (and if singleFile is false) then this script will load
   * *all* Prodige scripts. If window.Prodige is set to an array
   * then this script will attempt to load scripts for each string of
   * the array, using the string as the src of the script.
   *
   * Example:
   * (code)
   *     <script type="text/javascript">
   *         window.Prodige = [
   *             "Prodige/Util.js",
   *             "Prodige/BaseTypes.js"
   *         ];
   *     </script>
   *     <script type="text/javascript" src="../lib/Prodige.js"></script>
   * (end)
   * In this example Prodige.js will load Util.js and BaseTypes.js only.
   */
  var jsFiles = window.Prodige;

  /**
   * Namespace: Prodige
   * L'objet Prodige fourni un namespace pour tous les composants de l'API Prodige
   */
  window.Prodige = {
  	mainProjections : [],
    /**
     * Method: _getScriptLocation
     * Retourne le chemin absolu du fichier courant. 
     *
     * Returns:
     * {String} - Chemin vers le script courant
     */
    _getScriptLocation: (function() {
        var r = new RegExp("(^|(.*?\\/))(" + scriptName + ")(\\?|$)"),
            s = document.getElementsByTagName('script'),
            src, m, l = "";
        for(var i=0, len=s.length; i<len; i++) {
            src = s[i].getAttribute('src');
            if(src && src.indexOf(scriptName)!=-1 ) {
                m = src.match(r);
                if(m) {
                    l = m[1];
                    break;
                }
            }
        }
        
        return (function() { return l; });
    })(),
    
    /**
     * APIProperty: ImgPath
     * {String} Set this to the path where control images are stored, a path  
     * given here must end with a slash. If set to '' (which is the default) 
     * Prodige will use its script location + "img/".
     * 
     * You will need to set this property when you have a singlefile build of 
     * Prodige that either is not named "Prodige.js" or if you move
     * the file in a way such that the image directory cannot be derived from 
     * the script location.
     * 
     * If your custom Prodige build is named "my-custom-ol.js" and the images
     * of Prodige are in a folder "/resources/external/images/ol" a correct
     * way of including Prodige in your HTML would be:
     * 
     * (code)
     *   <script src="/path/to/my-custom-ol.js" type="text/javascript"></script>
     *   <script type="text/javascript">
     *      // tell Prodige where the control images are
     *      // remember the trailing slash
     *      Prodige.ImgPath = "/resources/external/images/ol/";
     *   </script>
     * (end code)
     * 
     * Please remember that when your Prodige script is not named 
     * "Prodige.js" you will have to make sure that the default theme is 
     * loaded into the page by including an appropriate <link>-tag, 
     * e.g.:
     * 
     * (code)
     *   <link rel="stylesheet" href="/path/to/default/style.css"  type="text/css">
     * (end code)
     */
    ImgPath : '',
    readyListeners : [],
    
    /**
     * Method: onReady
     * Enregistre une fonction qui devra être appelée à l'issue du chargement complet de l'API Prodige
     *
     * Params:
     * {Function} - La fonction à appeler
     * {Object|undefined} - L'objet sur lequel cette fonction devra être exécuté (si rien : Window) 
     */
    onReady : function(fn, scope){
      this.readyListeners.push({fn : fn, scope : scope || window});
    },
    ready : function(){
      for(var i=0; i<this.readyListeners.length; i++){
        this.readyListeners[i].fn.apply(this.readyListeners[i].scope);
      }
      this.readyListeners = [];
    },
    addScriptJs : function(tabJs, iScript, aliases){
      var me = this;
      var h = document.getElementsByTagName("head").length ? 
              document.getElementsByTagName("head")[0] : 
              document.body;
      var len = tabJs.length;
      var s = document.createElement("script");
      s.type = 'text/JavaScript';
      if ( iScript==(len-1) ){
        s.onload = function(){          
          for(var carmenClass in aliases ){
              var prodigeClass = aliases[carmenClass];
              if ( typeof eval(prodigeClass) != "undefined" && typeof eval(carmenClass) == "undefined" ){
                eval(carmenClass+" = "+prodigeClass);
              }
          }
          me.ready()
        };
      } else if ( iScript<len ){
        s.onload = function(){ me.addScriptJs(tabJs, iScript+1, aliases);};
      } else {
        return;
      }
      s.src = tabJs[iScript];
      h.appendChild(s);
    },
    
    /**
     * Method: loadJsFiles
     * Charge tous les fichiers de la librairie Prodige puis exécute les fonctions enregistrées par le onReady.
     * L'argument noCache permet lorsqu'il vaut TRUE, d'assurer que les fichiers JS chargés ne seront pas des versions mises en cache du navigateur.
     * 
     * *Note* : Il convient donc de renseigner l'ensemble des actions onReady avant de demander le chargement de la librairie.
     *  
     * 
     * *Example* :
     * (start code)
     * <html>
     * <head>
     * <script type="text/javascript">
     *   CARMEN_URL_SERVER_DATA = 'http://[FRONTAL_PRODIGE]';
     * </script>
     * 
     * <!-- 
     *   -- Librairies pouvant avoir une autre provenance. 
     *   -->
     * <!-- COMPATIBILITE MINIMALE OPENLAYERS = v2.12 -->
     * <script src="http://[FRONTAL_PRODIGE]/IHM/JavaScript/[LIBRAIRIE OPENLAYERS]/OpenLayers.js"></script>
     * <script src="http://[FRONTAL_PRODIGE]/IHM/JavaScript/proj4js/lib/proj4js.js"></script>
     * 
     * <!-- 
     *   -- Librairies de l'API
     *   -->
     * <!-- Chargement des projections appliquées en France -->
     * <script type="text/javascript" src="http://[VIEWER_PRODIGE]/lib/proj4Defs/allProjections.js"></script>
     * <script type="text/javascript" src="http://[VIEWER_PRODIGE]/lib/Prodige/ProdigeViewer.js"></script>
     * 
     * <script type="text/javascript">
     * function createMap(){
     *   prodigemap = new Prodige.Map({
     *   
     *     owscontext : 'http://[FRONTAL_PRODIGE]/services/GetContext/load.php?map=[FICHIER_MAPFILE].map',
     *  //OU
     *     owscontext : 'http://[DONNEES_PRODIGE]/[FICHIER_OWS].ows',
     *     
     *     id : "example1",
     *     renderTo : "prodigeviewer",
     *     legendVisible : true,
     *     keymapVisible : true,
     *     defaultControl : 'Navigation',
     *     legendRenderer : 'advanced'
     *   });
     * }
     * 
     * var onPageReady = function (){
     *   Prodige.onReady(createMap);
     *   Prodige.loadJsFiles(false);
     * }
     * </script>
     * 
     * </head>
     * 
     * <body onload="onPageReady()">
     *   <div id='prodigeviewer' style="width:100%;  height:500px;">
     *     <div id='prodigeviewerMap' class="PRODIGEAPI_MAP"></div>
     *     <div id='layerManagerPanel' class="PRODIGEAPI_LEGEND"></div>
     *   </div>
     * </body>
     * </html>
     * (end)
     * 
     * Params:
     * {Boolean|undefined} - Si TRUE : Certifie que les fichiers JS chargés ne proviennent pas du cache navigateur 
     */
    loadJsFiles : function(noCache)
    {

      /**
       * Prodige.singleFile is a flag indicating this file is being included
       * in a Single File Library build of the Prodige Library.
       * 
       * When we are *not* part of a SFL build we dynamically include the
       * Prodige library code.
       * 
       * When we *are* part of a SFL build we do not dynamically include the 
       * Prodige library code as it will be appended at the end of this file.
       */
      if (!singleFile && !jsFiles) {
        jsFiles = [
            "Prodige/Util/OWSContext.js",
            "Prodige/Util/AbstractMapBuilder.js",
            "Prodige/Util/Tree.js",
            "Prodige/Keymap.js",
            "Prodige/Legend.js",
            "Prodige/NavToolbar.js",
            "Prodige/Map.js",
            "Prodige/Carmen/Util.js",
            "Prodige/Carmen/Control/AttributionCarmen.js",
            "Prodige/Carmen/Control/MapserverScale.js",
            "Prodige/Carmen/Layer/MapServerGroup.js",
            "Prodige/Carmen/Layer/WMSGroup.js",
            "Prodige/Carmen/Layer/WMTSGroup.js",
            "Prodige/Carmen/Layer/Vector.js",
            "Prodige/Carmen/MapViewer.js"
        ]; 
      } else {
        jsFiles = [];
      }
      var host = Prodige._getScriptLocation() + "lib/";
      for(var i=0; i<jsFiles.length; i++){
        jsFiles[i] = host + jsFiles[i]
      }

      if ( noCache ){
        for(var i=0; i<jsFiles.length; i++){
          jsFiles[i] += "?_dc="+(new Date().getTime());
        }
      }
      
      var aliases = {
        "Carmen.Control.ReferenceMap"     : "Prodige.Keymap",
        "Carmen.Control.LayerTreeManager" : "Prodige.Legend"
      };
  
      // use "parser-inserted scripts" for guaranteed execution order
      // http://hsivonen.iki.fi/script-execution/
      Prodige.addScriptJs(jsFiles, 0, aliases);
    }
  };
})();


/**
 * Constant: VERSION_NUMBER
 */
Prodige.VERSION_NUMBER="1.0";